<?php

namespace AgeGateLogs\Traits;

trait Settings
{
    public static $options = [
        'perPage',
        'deleteAfter',
        'pass',
        'fail',
        'ip',
        'entry',
        'entryType',
        'custom',
        'errors',
        'ageRequired',
        'ageGiven',
        'content',
    ];

    public static $defaultOptions = [
        'perPage' => 20,
        'deleteAfter' => '',
        'pass' => 1,
        'fail' => 1,
        'ip' => 0,
        'entry' => 1,
        'entryType' => 1,
        'custom' => 0,
        'errors' => 1,
        'ageRequired' => 1,
        'ageGiven' => 1,
        'content' => 1,
    ];

    public static function mergeOptions($data = [])
    {
        return array_merge(
            array_fill_keys(self::$options, null),
            \AgeGateLogs\Util\Helper::deepStripslashes($data)
        );
    }
}
