<?php

namespace AgeGateLogs\Admin;

class Addon
{
    private $config;

    public function __construct()
    {
        $this->updateCheck();

        if (file_exists(WP_PLUGIN_DIR . '/age-gate/admin/config/config.php')) {
            $this->config = include WP_PLUGIN_DIR . '/age-gate/admin/config/config.php';
        } else {
            $this->config = [];
        }

        add_action('admin_menu', [$this, 'registerAddon'], 100);
        add_filter('age_gate_admin_tabs', [$this, 'adminTab']);
        add_action('admin_notices', [$this, 'dependancyNotice']);
    }

    public function registerAddon()
    {
        add_submenu_page(
            'age-gate',
            __('Age Gate Logs', 'age-gate-logs'),
            __('Logs', 'age-gate-logs'),
            'ag_manage_settings',
            'age-gate-logs',
            [$this, 'displayOptionsPage'],
            99
        );
    }

    public function displayOptionsPage()
    {
        $settings = new Pages\Settings;
        if (isset($_GET['tab']) && $_GET['tab'] === 'settings') {
            include AGE_GATE_LOGS_PATH . 'src/Resources/views/admin/admin-settings.php';
        } else {
            $logs = new Pages\Logs;

            $totalResults = $logs->getLogCount();
            $perPage = $settings->perPage ?: 10;
            $page = $_GET['pageNum'] ?? 1;
            
            if ($page <= 0) {
                $page = 1;
            }
            
            $pageOffset = ($page - 1) * $perPage;
            $totalPages = ceil($totalResults / $perPage);

            $orderBy = $_GET['orderBy'] ?? 'date';
            $order = $_GET['order'] ?? 'DESC';

            include AGE_GATE_LOGS_PATH . 'src/Resources/views/admin/admin-logs.php';
        }
    }

    public function adminTab($tabs)
    {
        $tabs['age-gate-logs'] = [
            'cap' => 'ag_manage_settings',
            'title' =>  _x('Logs', 'Admin tab title', 'age-gate-logs'),
        ];

        return $tabs;
    }

    /**
     * Checks the plugin version against the stored version
     * and updates the settings if mismatched
     *
     * @since 0.0.0
     *
     */
    private function updateCheck()
    {
        if (AGE_GATE_LOGS_VERSION !== get_option('wp_age_gate_logs_version') || intval(get_option('wp_age_gate_logs_db_version')) < AGE_GATE_LOGS_DB_VERSION) {
            \AgeGateLogs\Update\Activate::activate();
        }
    }

    public function dependancyNotice()
    {
        if (!\AgeGateLogs\Util\Dependency::versionCheck()) {
            echo sprintf('<div id="message" class="notice notice-warning is-dismissible"><p>'. __('Age Gate Logs requires at least Age Gate %s', 'age-gate-region') .'</p></div>', AGE_GATE_LOGS_DEPENDANCY);
        }
    }
}
