<?php

namespace AgeGateLogs\Update;

class Update
{
    private $pluginName = 'age-gate-logs';
    private $apiUrl;
    private $apiPassword = '';
    private $pluginVersion;

    public function __construct()
    {
        add_filter('pre_set_site_transient_update_plugins', [$this, 'displayTransientUpdate']);
        add_filter('plugins_api', [$this, 'pluginsApiHandler'], 10, 3);
    }

    public function setApiUrl()
    {
        $this->apiUrl = "https://api.asylum.london/?forcePass={$this->apiPassword}&version=latest&plugin=" . $this->pluginName;
    }

    public function setPluginVersion()
    {
        $plugin = get_plugin_data(AGE_GATE_LOGS_PATH . '/' . $this->pluginName . '.php');
        $this->pluginVersion = $plugin['Version'];
    }

    public function displayTransientUpdate($transient)
    {
        $this->setApiUrl();

        if (!$this->apiUrl) {
            return $transient;
        }

        $api = add_query_arg('forcePassword', $this->apiPassword, $this->apiUrl);

        $response = wp_remote_get($api);
        $data = json_decode(wp_remote_retrieve_body($response), true);

        if (is_wp_error($response)) {
            return $transient;
        }

        $this->setPluginVersion();


        if (!isset($data['latest_version'])) {
            return $transient;
        }

        $result = $data['latest_version'];

        $updateVersion = $result;

        /* Latest Release Update */
        if (preg_match("/version=latest/", $this->apiUrl)) {
            if (version_compare($this->pluginVersion, $updateVersion, '<')) {
                $transient->response["{$this->pluginName}/{$this->pluginName}.php"] = $this->transientObject($data);
                return $transient;
            }
        }

        /* Specific Version Update */
        // if (version_compare($this->pluginVersion, $updateVersion, '!=')) {
        //     $transient->response["{$this->pluginName}/{$this->pluginName}.php"] = $this->transientObject($data);
        //     return $transient;
        // }

        return $transient;
    }

    public function transientObject($data)
    {
        $updateVersion = $data['latest_version'];

        $response = new \stdClass();
        $response->slug = $data['slug'];
        $response->new_version = $updateVersion;
        $response->url = $data['url'];
        $response->package = $data['package'] . '&forcePass=' . $this->apiPassword;
        $response->icons = [
            '2x' => AGE_GATE_LOGS_URL . '/dist/img/thumbnail-256x256.png',
            '1x' => AGE_GATE_LOGS_URL . '/dist/img/thumbnail-128x128.png'
        ];
        $response->tested = $data['tested'] ?? '5.5';
        return $response;
    }

    public function pluginsApiHandler($res, $action, $args)
    {
        if ($action === 'plugin_information') {
            if (isset($args->slug) && $args->slug === basename(AGE_GATE_LOGS_PATH)) {
                $this->setApiUrl();

                $api = add_query_arg('forcePassword', $this->apiPassword, $this->apiUrl);
                
                $response = wp_remote_get($api);

                if (is_wp_error($response)) {
                    return $res;
                }
                $data = json_decode(wp_remote_retrieve_body($response));
                
                $res = new \stdClass();
                $res->name = 'Age Gate Logs';
                $res->version = $data->latest_version;
                $res->slug = $data->slug;
                $res->download_link = $data->package;
                $res->tested = $data->tested;
                $res->requires = $data->requires;
                $res->requires_php = $data->requires_php;
                $res->last_updated = isset($data->date) ? $data->date : '';
                $res->homepage = 'https://agegate.io/addons/age-gate-regions';
 
                $res->sections = [
                    'description' => (isset($data->description) ? $data->description : 'Functionality for the site.'),
                    // 'installation' => '<ul><li>Upload plugin</li></ul>',
                    // 'faq' => '',
                    // 'screenshots' => '',
                ];
 
                $res->banners = [
                    'low' => AGE_GATE_LOGS_URL . '/dist/img/banner-772x250.png',
                    'high' => AGE_GATE_LOGS_URL . '/dist/img/banner-772x250.png'
                ];
 
                $res->external = true;
                
                // Add change log tab if the server sent it
                if (isset($data->changelog)) {
                    $res->sections['changelog'] = $data->changelog;
                }
    
                return $res;
            }
        }

        return $res;
    }
}
