<?php

namespace AgeGateLogs\Util;

class Data
{
    private $config;
    private $coreSettings = [
        'restrictions',
        'messages',
        'appearance',
        'advanced',
    ];

    public $includePath = WP_PLUGIN_DIR . '/age-gate/public/partials/';

    public function __construct()
    {
        $this->config = $this->getConfig();
        $this->config->defaults->logs = [
            'perPage',
            'ip',
            'entry',
            'entryType',
            'custom',
            'pass',
            'fail',
            'ageRequired',
            'ageGiven',
            'content',
            'errors',
            'deleteAfter'
        ];
    }

    public function getSettings()
    {
        $data = get_option('wp_age_gate_logs', []) ?: [];
        return $this->filterSettings('logs', $data);
    }

    public function getCoreSettings($setting = false)
    {
        $data = [];

        if ($setting) {
            $settings = get_option('wp_age_gate_' . $setting, []) ?: [];
            $data = $this->filterSettings($setting, $settings);
        } else {
            foreach ($this->coreSettings as $setting) {
                $settings = get_option('wp_age_gate_' . $setting, []) ?: [];
                $data[$setting] = $this->filterSettings($setting, $settings);
            }
        }

        return (object) $data;
    }

    private function filterSettings($type, $data = [])
    {
        $defaults = array_fill_keys(array_values($this->config->defaults->{$type}), null);
        return (object) array_merge(
            $defaults,
            Helper::deepStripslashes($data),
        );
    }

    public function getConfig()
    {
        if (file_exists(WP_PLUGIN_DIR . '/age-gate/admin/config/config.php')) {
            return include WP_PLUGIN_DIR . '/age-gate/admin/config/config.php';
        }

        return (object) ['defaults' => (object) []];
    }

    public function msgFormat($options)
    {
        $msgs = [
            'headline' => $options->instruction,
            'subheadline' => $options->messaging,
            'errors' => (object) [
                'invalid' => $options->invalid_input_msg,
                'failed' => $options->under_age_msg,
                'generic' => $options->generic_error_msg,
            ],
            'remember' => $options->remember_me_text,
            'buttons' => (object) [
                'message' => $options->yes_no_message,
                'yes' => $options->yes_text,
                'no' => $options->no_text,
            ],
            'labels' => (object) [
                'day' => $options->text_day,
                'month' => $options->text_month,
                'year' => $options->text_year
            ],
            'additional' => $options->additional,
            'submit' => $options->button_text
        ];

        return (object) $msgs;
    }
}
