<?php

namespace AgeGateLogs\Submission;

use AgeGateLogs\Admin\Pages\Settings;

class Form
{
    public function __construct()
    {
        add_action('init', [$this, 'ageGateActions']);
    }

    public function ageGateActions()
    {
        $settings = new Settings;

        if ($settings->pass) {
            // AG v2
            add_action('age_gate_form_success', [$this, 'logData'], 10, 2);

            // AG V3
            add_action('age_gate/submission/success', [$this, 'logV3Data'], 10, 3);
        }

        if ($settings->fail) {
            // AG V2
            add_action('age_gate_form_failed', [$this, 'logData'], 10, 2);

            // AG V3
            add_action('age_gate/submission/failed', [$this, 'logV3Data'], 10, 3);
        }
    }

    public function logData($formData, $errors = [])
    {
        global $wpdb;

        $region = $formData['ag-region'] ?? 'N/A';

        $coreSettings = get_option('wp_age_gate_restrictions', []);

        $table = $wpdb->prefix . \AgeGateLogs\Update\Activate::$ageGateLogTable;
        $custom = [];
        foreach ($formData as $key => $value) {
            if (substr($key, 0, 8) !== 'age_gate') {
                $custom[$key] = $value;
                unset($formData[$key]);
            }
        }

        unset($custom['confirm_action']);

        if ($coreSettings['input_type'] !== 'buttons') {
            $input = sprintf('%d-%d-%d', $formData['age_gate_y'], $formData['age_gate_m'], $formData['age_gate_d']);
            try {
                $givenAge = \AgeGateLogs\Util\Age::calcAge($input);
            } catch (\Exception $e) {
                $givenAge = 0;
            }
        } else {
            if ($formData['age_gate_confirm']) {
                $input = 'Yes';
                $givenAge = $formData['age_gate_age'];
            } else {
                $input = 'No';
                $givenAge = 0;
            }
        }

        $settings = new Settings;

        $logData = [
            'logIp'             => $settings->ip ? $_SERVER['REMOTE_ADDR'] : null,
            'logEntry'          => $settings->entry ? $input : null,
            'logEntryType'      => $settings->entryType ? $coreSettings['input_type'] : null,
            'logCustom'         => $settings->custom ? maybe_serialize($custom) : null,
            'logStatus'         => current_action() === 'age_gate_form_success' ? 'pass' : 'fail',
            'logAgeRequired'    => $settings->ageRequired ? $formData['age_gate_age'] ?? null : null,
            'logAgeGiven'       => $settings->ageGiven ? $givenAge : '',
            'logContent'        => $settings->content ? $formData['age_gate_content'] ?? null : null,
            'logText'           => $settings->errors ? maybe_serialize($errors) : null,
            'logRegion'         => $region,
            'logDate'           => date('Y-m-d H:i:s'),
        ];

        $wpdb->insert(
            $table,
            $logData,
        );
    }

    public function logV3Data($data, $errors, $custom)
    {
        $settings = new Settings;

        $coreSettings = get_option('age_gate_restrictions', []);
        switch ($coreSettings['input_type']) {
            case 'buttons':
                if (($data['age_gate_confirm'] ?? false) == 1) {
                    $input = 'Yes';
                    $givenAge = $data['age_gate_age'];
                } else {
                    $input = 'No';
                    $givenAge = 0;
                }
                break;
            default:
                $input = sprintf('%d-%d-%d', $data['age_gate_y'], $data['age_gate_m'], $data['age_gate_d']);
                $givenAge = \AgeGateLogs\Util\Age::calcAge($input);
                break;
        }

        $logData = [
            'logIp'             => $settings->ip ? $_SERVER['REMOTE_ADDR'] : null,
            'logEntry'          => $settings->entry ? $input : null,
            'logEntryType'      => $settings->entryType ? $coreSettings['input_type'] : null,
            'logCustom'         => $settings->custom ? maybe_serialize($custom) : null,
            'logStatus'         => current_action() === 'age_gate/submission/success' ? 'pass' : 'fail',
            'logAgeRequired'    => $settings->ageRequired ? $data['age_gate_age'] ?? null : null,
            'logAgeGiven'       => $settings->ageGiven ? $givenAge : '',
            'logContent'        => $settings->content ? $data['age_gate_content'] ?? null : null,
            'logText'           => $settings->errors ? maybe_serialize($errors) : null,
            'logRegion'         => $custom['age_gate.region'] ?? 'N/A',
            'logDate'           => date('Y-m-d H:i:s'),
        ];

        $this->store($logData);
    }

    private function store($logData = [])
    {
        global $wpdb;
        $table = $wpdb->prefix . \AgeGateLogs\Update\Activate::$ageGateLogTable;


        $wpdb->insert(
            $table,
            $logData,
        );
    }
}
