<?php

namespace AgeGateLogs\Admin\Pages;

class Logs
{
    private $tableName;

    public function __construct()
    {
        global $wpdb;
        $this->tableName = $wpdb->prefix . \AgeGateLogs\Update\Activate::$ageGateLogTable;
    }

    public function getLogs($limit = 10, $offset = 0, $orderBy = 'date', $order = 'DESC')
    {
        global $wpdb;

        $orderBy = 'log' . ucfirst(strtolower($orderBy));

        return $wpdb->get_results("SELECT * FROM {$this->tableName} ORDER BY {$orderBy} {$order} LIMIT {$limit} OFFSET {$offset}");
    }

    public function getLogCount()
    {
        global $wpdb;
        return $wpdb->get_var("SELECT COUNT(*) FROM {$this->tableName}");
    }

    public function logOutput($value, $break = '<br />')
    {
        $value = maybe_unserialize($value);

        if (!is_array($value)) {
            return $value;
        }

        return implode($break, $value);
    }

    public function getSortLink($field)
    {
        $link = '<a href="%s" data-ag-tooltip="%s"><span class="dashicons dashicons-arrow-%s"></span></a>';
        $key = lcfirst(trim($field, 'log'));

        $args = [
            'orderBy' => $key,
        ];

        $order = 'ASC';

        if (isset($_GET['orderBy']) && $_GET['orderBy'] === $key) {
            $order = isset($_GET['order']) && $_GET['order'] === 'ASC' ? 'DESC' : 'ASC';
        }

        $args['order'] = $order;
        $args = array_filter($args);

        return sprintf(
            $link,
            add_query_arg($args),
            "Order " . $order === 'ASC' ? 'ascending' : 'decending',
            $order === 'ASC' ? 'down' : 'up'
        );
    }
}
