<?php

/**
 * Plugin Name:       	 Age Gate Logs
 * Description:       	 Keep track of passes and failures in your Age Gate
 * Version:           	 1.2.0
 * Author:            	 Asylum Digital
 * Author URI:        	 https://www.asylumdigital.co.uk
 * Text Domain:       	 age-gate-logs
 */

 if (!defined('WPINC')) {
     die;
 }

define('AGE_GATE_LOGS_PATH', plugin_dir_path(__FILE__));
define('AGE_GATE_LOGS_URL', plugin_dir_url(__FILE__));
define('AGE_GATE_LOGS_VERSION', '1.2.0');
define('AGE_GATE_LOGS_DB_VERSION', '5');
define('AGE_GATE_LOGS_DEPENDANCY', '2.8.0');

if (!defined('AGE_GATE_CAP_RESTRICTIONS')) {
    define('AGE_GATE_CAP_RESTRICTIONS', 'ag_manage_restrictions');
}

if (!defined('AGE_GATE_CAP_APPEARANCE')) {
    define('AGE_GATE_CAP_APPEARANCE', 'ag_manage_appearance');
}

if (!defined('AGE_GATE_CAP_ADVANCED')) {
    define('AGE_GATE_CAP_ADVANCED', 'ag_manage_advanced');
}

if (!defined('AGE_GATE_CAP_MESSAGING')) {
    define('AGE_GATE_CAP_MESSAGING', 'ag_manage_messaging');
}

if (!defined('AGE_GATE_CAP_ACCESS')) {
    define('AGE_GATE_CAP_ACCESS', 'ag_manage_settings');
}

if (!defined('AGE_GATE_CAP_SET_CONTENT')) {
    define('AGE_GATE_CAP_SET_CONTENT', 'ag_manage_set_content_restriction');
}

if (!defined('AGE_GATE_CAP_SET_BYPASS')) {
    define('AGE_GATE_CAP_SET_BYPASS', 'ag_manage_set_content_bypass');
}

if (!defined('AGE_GATE_CAP_SET_CUSTOM_AGE')) {
    define('AGE_GATE_CAP_SET_CUSTOM_AGE', 'ag_manage_set_custom_age');
}

require_once('vendor/autoload.php');
require_once('src/Bootstrap.php');

function age_gate_logs_activate()
{
    \AgeGateLogs\Update\Activate::activate();
}

function age_gate_logs_deactivate()
{
    \AgeGateLogs\Update\Deactivate::deactivate();
}

function my_plugin_uninstall()
{
    \AgeGateLogs\Update\Uninstall::uninstall();
}


register_activation_hook(__FILE__, 'age_gate_logs_activate');
register_deactivation_hook(__FILE__, 'age_gate_logs_deactivate');
register_uninstall_hook(__FILE__, 'age_gate_logs_uninstall');
