<?php

namespace AgeGateLogs\Util;

class Dependency
{
    public static function versionCheck()
    {
        $agVersion = defined('AGE_GATE_VERSION') ? AGE_GATE_VERSION : (get_option('wp_age_gate_version', false) ?: false);
        
        if (! function_exists('is_plugin_active')) {
            function is_plugin_active($plugin)
            {
                return in_array($plugin, (array) get_option('active_plugins', []));
            }
        }


        if (!is_plugin_active('age-gate/age-gate.php') || !$agVersion || version_compare($agVersion, AGE_GATE_LOGS_DEPENDANCY, '<')) {
            return false;
        }

        return true;
    }
}
