<?php

namespace AgeGateLogs\Update;

class Activate
{
    use \AgeGateLogs\Traits\Settings;

    public static $ageGateLogTable = 'age_gate_logs';
    
    public static function activate()
    {
        if (! wp_next_scheduled('age_gate_logs_cron')) {
            wp_schedule_event(time(), 'daily', 'age_gate_logs_cron');
        }

        if (intval(get_option('wp_age_gate_logs_db_version')) < AGE_GATE_LOGS_DB_VERSION) {
            if (self::databaseTables()) {
                update_option('wp_age_gate_logs_db_version', AGE_GATE_LOGS_DB_VERSION);
            }
        }

        $userOptions = get_option('wp_age_gate_logs', []) ?: [];
        $settings = array_merge(self::$defaultOptions, $userOptions);

        update_option('wp_age_gate_logs', $settings);
        update_option('wp_age_gate_logs_version', AGE_GATE_LOGS_VERSION);
    }

    private static function databaseTables()
    {
        global $wpdb;

        $charset_collate = '';
        
        if (!empty($wpdb->charset)) {
            $charset_collate = "DEFAULT CHARACTER SET {$wpdb->charset}";
        }
        if (!empty($wpdb->collate)) {
            $charset_collate .= " COLLATE {$wpdb->collate}";
        }

        require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
        
        $tableName = $wpdb->prefix . self::$ageGateLogTable;

        $sql = "CREATE TABLE " . $tableName . " (
            id int(11) NOT NULL AUTO_INCREMENT ,
            logIp varchar(50) DEFAULT NULL ,
            logEntry varchar(200) DEFAULT NULL ,
            logEntryType varchar(20) DEFAULT NULL ,
            logCustom varchar(200) DEFAULT NULL ,
            logStatus varchar(4) DEFAULT NULL ,
            logAgeRequired int(4) DEFAULT NULL ,
            logAgeGiven int(4) DEFAULT NULL ,
            logContent varchar(255) DEFAULT NULL ,
            logText longtext DEFAULT NULL ,
            logDate datetime DEFAULT NULL , 
            logRegion varchar(255) DEFAULT NULL ,
            PRIMARY KEY  (id)
		) ". $charset_collate .";";
        
        dbDelta($sql);
        
        if ($wpdb->last_error) {
            wp_die($wpdb->last_error);
        }

        return true;
    }
}
