<div class="wrap age-gate-addon-content">
    <h2><?php echo esc_html(get_admin_page_title()); ?></h2>
    <?php //include WP_PLUGIN_DIR . '/age-gate/admin/partials/parts/tabs.php';?>

    <ul class="subsubsub">
        <li>
            <a href="<?php echo remove_query_arg('tab'); ?>" class="current">Logs</a> | 
        </li>
        <li>
            <a href="<?php echo add_query_arg(['tab' => 'settings'], remove_query_arg([
                'perPage',
                'pageNum',
                'orderBy',
                'order',
            ])); ?>">Settings</a>
        </li>
    </ul>
    <form class="custom-form-fields ag-user-registration-form" action="admin-post.php" method="post">
    
    </form>
    <br />
    <?php
        $region = false;

        if (is_plugin_active('age-gate-region/age-gate-region.php')) {
            $region = get_option('wp_age_gate_regions', []);
        }
    ?>

    <table class="wp-list-table widefat striped table-view-list age-gate-logs">
        <thead>
            <tr>
                <th>Date <?php echo $logs->getSortLink('logDate') ?></th>
                <?php if ($settings->ip) : ?>
                <th>IP Address <?php echo $logs->getSortLink('logIp') ?></th>
                <?php endif; ?>
                <?php if ($settings->entry) : ?>
                <th>Entry <?php echo $logs->getSortLink('logEntry') ?></th>
                <?php endif; ?>
                <?php if ($settings->entryType) : ?>
                <th>Entry type <?php echo $logs->getSortLink('logEntryType') ?></th>
                <?php endif; ?>
                <?php if ($settings->pass || $settings->fail) : ?>
                <th>Status <?php echo $logs->getSortLink('logStatus') ?></th>
                <?php endif; ?>
                <?php if ($settings->ageRequired) : ?>
                <th>Required age <?php echo $logs->getSortLink('logAgeRequired') ?></th>
                <?php endif; ?>
                <?php if ($settings->ageGiven) : ?>
                <th>Given age <?php echo $logs->getSortLink('logAgeGiven') ?></th>
                <?php endif; ?>
                <?php if ($settings->content) : ?>
                <th>URL <?php echo $logs->getSortLink('logContent') ?></th>
                <?php endif; ?>
                <?php if ($settings->errors) : ?>
                <th>Errors <?php echo $logs->getSortLink('logText') ?></th>
                <?php endif; ?>
                <?php if ($region) : ?>
                <th>Region <?php echo $logs->getSortLink('logRegion') ?></th>
                <?php endif; ?>
                <?php if ($settings->custom) : ?>
                <th>Custom <?php echo $logs->getSortLink('logCustom') ?></th>
                <?php endif; ?>
            </tr>
        </thead>
        <?php foreach ($logs->getLogs($perPage, $pageOffset, $orderBy, $order) as $log) : ?>
            <tr>
                <td>
                    <?php echo date(get_option('date_format'), strtotime($logs->logOutput($log->logDate))); ?> 
                    <?php echo date(get_option('time_format'), strtotime($logs->logOutput($log->logDate))); ?>
                </td>
                <?php if ($settings->ip) : ?>
                    <td><?php echo $logs->logOutput($log->logIp); ?></td>
                <?php endif; ?>
                <?php if ($settings->entry) : ?>
                    <td><?php echo $logs->logOutput($log->logEntry); ?></td>
                <?php endif; ?>
                <?php if ($settings->entryType) : ?>
                    <td><?php echo ucfirst($logs->logOutput($log->logEntryType)); ?></td>
                <?php endif; ?>
                <?php if ($settings->pass || $settings->fail) : ?>
                    <td>
                        <span class="ag-log__indicator ag-log__indicator--<?php echo $logs->logOutput($log->logStatus); ?>"></span>
                        <?php echo ucfirst($logs->logOutput($log->logStatus)); ?>
                    </td>
                <?php endif; ?>
                <?php if ($settings->ageRequired) : ?>
                    <td><?php echo $logs->logOutput($log->logAgeRequired); ?></td>
                <?php endif; ?>
                <?php if ($settings->ageGiven) : ?>
                    <td><?php echo $logs->logOutput($log->logAgeGiven); ?></td>
                <?php endif; ?>
                <?php if ($settings->content) : ?>
                    <td><?php echo $logs->logOutput($log->logContent); ?></td>
                <?php endif; ?>
                <?php if ($settings->errors) : ?>
                    <td><?php echo $logs->logOutput($log->logText); ?></td>
                <?php endif; ?>
                <?php if ($region) : ?>
                    <?php
                        if ($region['region'][$log->logRegion] ?? false) {
                            $label = sprintf('%s (%s)', $region['region'][$log->logRegion]['title'], $region['region'][$log->logRegion]['code']);
                        } else {
                            $label = $log->logRegion;
                        }
                    ?>
                    <td><?php echo $logs->logOutput($label); ?></td>
                <?php endif; ?>
                <?php if ($settings->custom) : ?>
                    <td><?php echo $logs->logOutput($log->logCustom); ?></td>
                <?php endif; ?>

            </tr>
        <?php endforeach; ?>
    </table>
    <?php if ($totalPages) : ?>
    <form method="get" action="<?php echo remove_query_arg('pageNum'); ?>">
        <input type="hidden" name="page" value="<?php echo $_GET['page']; ?>">
        <div class="age-gate__logs-pagingation alignright">
            <div class="tablenav-pages">
                <span class="displaying-num"><?php echo $totalResults; ?> items</span>
                <span class="pagination-links">
                    <?php if ($page == 1) : ?>
                    <span class="tablenav-pages-navspan button disabled" aria-hidden="true">«</span>
                    <span class="tablenav-pages-navspan button disabled" aria-hidden="true">‹</span>
                    <?php else : ?>
                    <a class="next-page button" href="<?php echo add_query_arg(['pageNum' => 1]); ?>">
                        <span class="screen-reader-text">First page</span>
                        <span aria-hidden="true">«</span>
                    </a>

                    <a class="next-page button" href="<?php echo add_query_arg(['pageNum' => $page - 1]); ?>">
                        <span class="screen-reader-text">Previous page</span>
                        <span aria-hidden="true">‹</span>
                    </a>
                    <?php endif; ?>
                    
                    <span class="paging-input">
                        <label for="current-page-selector" class="screen-reader-text">Current Page</label>
                        <input class="current-page" id="current-page-selector" type="text" name="pageNum" value="<?php echo $page; ?>" size="1" aria-describedby="table-paging">
                        <span class="tablenav-paging-text"> of <span class="total-pages"><?php echo $totalPages; ?></span></span>
                    </span>
                    
                    <?php if ($page != $totalPages) : ?>
                    <a class="next-page button" href="<?php echo add_query_arg(['pageNum' => $page + 1]); ?>">
                        <span class="screen-reader-text">Next page</span>
                        <span aria-hidden="true">›</span>
                    </a>
                    <a class="next-page button" href="<?php echo add_query_arg(['pageNum' => $totalPages]); ?>">
                        <span class="screen-reader-text">Last page</span>
                        <span aria-hidden="true">»</span>
                    </a>
                    <?php else : ?>               
                    <span class="tablenav-pages-navspan button disabled" aria-hidden="true">›</span>
                    <span class="tablenav-pages-navspan button disabled" aria-hidden="true">»</span>
                    <?php endif; ?>
                </span>
            </div>
        </div>
    </form>
    <?php endif; ?>
</div>
