<?php

namespace AgeGateLogs\Data;

use AgeGateLogs\Util\Form;
use AgeGateLogs\Admin\Pages\Logs;

class Export
{
    private $data;
    private $get;

    public function __construct()
    {
        $this->data = new Form;
        $this->get = $this->data->sanitize($_GET);
        if (is_admin() && isset($this->get['page']) && $this->get['page'] === 'age-gate-logs' && isset($this->get['tab']) && $this->get['tab'] === 'settings' && isset($this->get['action']) && $this->get['action'] === 'export') {
            add_action('admin_init', [$this, 'exportData']);
        }
    }

    public function exportData()
    {
        if (!wp_verify_nonce($this->get['_wpnonce'], 'age_gate_logs_export')) {
            \AgeGateLogs\Util\Notice::setAminNotice(['message' => 'Unable to generate export', 'status' => 'error']);
            wp_redirect(remove_query_arg(['action', '_wpnonce']));
            return;
        }

        $logs = new Logs;
        $logData = $logs->getLogs($logs->getLogCount()) ?: new \stdClass;

        $headers = [
            'Date',
            'IP Address',
            'Entry',
            'Entry type',
            'Status',
            'Required age',
            'Given age',
            'URL',
            'Errors',
            'Custom'
        ];

        header('Content-Type: text/csv;charset=UTF-8');
        header("Content-Transfer-Encoding: Binary");
        header("Content-Disposition: attachment; filename=age-gate-logs_" . date('Ymd_His') . ".csv");
        echo "\xEF\xBB\xBF"; // UTF-8 BOM

        // create a file pointer connected to the output stream
        $output = fopen('php://output', 'w');

        fputcsv($output, $headers);

        foreach ($logData as $key => $row) {
            $line = [
                date(get_option('date_format'), strtotime($row->logDate)) . ' ' . date(get_option('time_format'), strtotime($row->logDate)),
                $logs->logOutput($row->logIp),
                $logs->logOutput($row->logEntryType),
                $logs->logOutput($row->logStatus),
                $logs->logOutput($row->logAgeRequired),
                $logs->logOutput($row->logAgeGiven),
                $logs->logOutput($row->logContent),
                $logs->logOutput($row->logText, "\r"),
                $logs->logOutput($row->logCustom, "\r"),
            ];

            fputcsv($output, $line);
        }

        fclose($output);
        die;
    }
}
