<?php

namespace AgeGateLogs\Data;

use AgeGateLogs\Util\Form;
use AgeGateLogs\Admin\Pages\Logs;

class Clear
{
    private $data;
    private $get;

    public function __construct()
    {
        $this->data = new Form;
        $this->get = $this->data->sanitize($_GET);
        if (is_admin() && isset($this->get['page']) && $this->get['page'] === 'age-gate-logs' && isset($this->get['tab']) && $this->get['tab'] === 'settings' && isset($this->get['action']) && $this->get['action'] === 'clear') {
            add_action('admin_init', [$this, 'clearData']);
        }
    }

    public function clearData()
    {
        if (!wp_verify_nonce($this->get['_wpnonce'], 'age_gate_logs_clear')) {
            \AgeGateLogs\Util\Notice::setAminNotice(['message' => __('Unable to delete data', 'age-gate-logs'), 'status' => 'error']);
            wp_redirect(remove_query_arg(['action', '_wpnonce']));
            return;
        }

        global $wpdb;

        $table = $wpdb->prefix . \AgeGateLogs\Update\Activate::$ageGateLogTable;
        $wpdb->query("TRUNCATE TABLE `$table`");

        if ($wpdb->last_error) {
            \AgeGateLogs\Util\Notice::setAminNotice(['message' => __('Fail: ' . $wpdb->last_error, 'age-gate-logs'), 'status' => 'error']);
        } else {
            \AgeGateLogs\Util\Notice::setAminNotice(['message' => __('All logs removed', 'age-gate-logs'), 'status' => 'success']);
        }

        wp_redirect(remove_query_arg(['action', '_wpnonce']));
        return;
    }
}
