<?php

namespace AgeGate\Region\Admin\Ajax;

use AgeGate\Region\Traits\Import;

class Ajax
{
    use Import;

    public function __construct()
    {
        add_action('wp_ajax_ag_region_import', [$this, 'loadImportData']);
    }

    public function loadImportData()
    {
        $dataSet = $_GET['set'];

        // if ($_GET['type'] === 'append') {
        //     $settings = get_option('wp_age_gate_regions', []) ?: [];
        //     $data = array_merge($this->{$dataSet}, $settings);
        // } else {
        // }

        if ('lang' === $dataSet) {
            $data = $this->getLanguages();
        } else {
            $data = $this->{$dataSet};

            foreach ($data as $code => $region) {
                if (!is_numeric($region['age'])) {
                    $data[$code]['age'] = 18;
                    $data[$code]['age_estimated'] = true;
                }
                $data[$code]['redirectOptions'] = '';//'<option value="" selected>' . __('Current page', 'age-gate-region') . '</option>';
            }
        }

        ksort($data);

        echo json_encode([
            'status' => 200,
            'type' => $_GET['type'],
            'data' => $data,
        ]);
        wp_die();
    }

    private function getLanguages()
    {
        $restrictions = get_option('wp_age_gate_restrictions', []);
        $data = [];

        foreach (icl_get_languages() as $code => $value) {
            $data[$code] = [
                'name' => $value['native_name'],
                'code' => $code,
                'age' => $restrictions['lang'][$code]['min_age'] ?? $restrictions['min_age'],
                'redirectOptions' => sprintf('<option value="%s" selected>%s</option>', $value['url'], __('Language landing', 'age-gate-region')),
            ];
        }

        return $data;
    }
}
