<h3><?php _e('Options', 'age-gate-region'); ?></h3>


<?php $settings = \Asylum\Utility\Arr::undot($data); ?>


<table class="form-table">
    <tbody>
        <tr>
            <th><?php _e('Placement', 'age-gate-region'); ?></th>
            <td>
                <select name="ag_settings[labels][placement]" class="regular-text ltr">
                    <option value="after"<?php echo (isset($settings['labels']['placement']) && $settings['labels']['placement'] === 'after') ? ' selected' : '';?>><?php _e('After form fields', 'age-gate-region'); ?></option>
                    <option value="before"<?php echo (isset($settings['labels']['placement']) && $settings['labels']['placement'] === 'before') ? ' selected' : '';?>><?php _e('Before form fields', 'age-gate-region'); ?></option>
                </select>
            </td>
        </tr>
        <tr>
            <th><?php _e('Label text', 'age-gate-region'); ?></th>
            <td>

                <?php if ($languages) : ?><img src="<?php echo $languages['default']['flag']; ?>" alt="" /> <?php endif; ?><input type="text" name="ag_settings[labels][label]" class="regular-text ltr" value="<?php echo $settings['labels']['label'] ?? ''; ?>" />
                <?php foreach ($languages['available'] ?? [] as $language) : ?>
                    <br />
                    <img src="<?php echo $language['flag']; ?>" alt="" /> <input type="text" name="ag_settings[labels][lang][<?php echo $language['code']; ?>][label]" class="regular-text ltr" value="<?php echo $settings['labels']['lang'][$language['code']]['label'] ?? ''; ?>" />
                <?php endforeach; ?>
            </td>
        </tr>
        <tr>
            <th><?php _e('Placeholder text', 'age-gate-region'); ?></th>
            <td>
                <?php if ($languages) : ?><img src="<?php echo $languages['default']['flag']; ?>" alt="" /> <?php endif; ?><input type="text" name="ag_settings[labels][placeholder]" class="regular-text ltr"  value="<?php echo $settings['labels']['placeholder'] ?? ''; ?>" />
                <?php foreach ($languages['available'] ?? [] as $language) : ?>
                        <br />
                        <img src="<?php echo $language['flag']; ?>" alt="" /> <input type="text" name="ag_settings[labels][lang][<?php echo $language['code']; ?>][placeholder]" class="regular-text ltr" value="<?php echo $settings['labels']['lang'][$language['code']]['placeholder'] ?? ''; ?>" />
                <?php endforeach; ?>
            </td>
        </tr>
        <tr>
            <th><?php _e('Forbidden error', 'age-gate-region'); ?></th>
            <td>

                <?php if ($languages) : ?><img src="<?php echo $languages['default']['flag']; ?>" alt="" /> <?php endif; ?><input type="text" name="ag_settings[labels][forbidden]" class="regular-text ltr"  value="<?php echo $settings['labels']['forbidden'] ?? ''; ?>" />

                <?php foreach ($languages['available'] ?? [] as $language) : ?>
                        <br />
                        <img src="<?php echo $language['flag']; ?>" alt="" /> <input type="text" name="ag_settings[labels][lang][<?php echo $language['code']; ?>][forbidden]" class="regular-text ltr" value="<?php echo $settings['labels']['lang'][$language['code']]['forbidden'] ?? ''; ?>" />
                <?php endforeach; ?>
                <p><small><?php _e('A region can be forbidden by setting the age to -1', 'age-gate-region'); ?></small></p>
            </td>
        </tr>
    </tbody>
</table>
