<?php

namespace AgeGate\Region\Enqueue;

class Enqueue
{
    public function __construct()
    {
        add_action('admin_enqueue_scripts', [$this, 'admin']);
        add_action('wp_enqueue_scripts', [$this, 'assets']);
    }

    public function admin()
    {
        if (isset($_GET['page']) && $_GET['page'] === 'age-gate-region') {
            wp_enqueue_script('jquery-ui-sortable');

            wp_enqueue_script('ag-serialize-object', AGE_GATE_REGION_URL . 'dist/jquery.serialize-object.min.js', ['jquery'], AGE_GATE_REGION_VERSION, true);
            wp_enqueue_style('age-gate-region-admin', AGE_GATE_REGION_URL . 'dist/admin.css', [], AGE_GATE_REGION_VERSION);
            wp_enqueue_script('age-gate-region-admin', AGE_GATE_REGION_URL . 'dist/admin.js', ['jquery', 'wp-util', 'jquery-ui-sortable', 'ag-serialize-object'], AGE_GATE_REGION_VERSION, true);
        }
    }

    public function assets()
    {
        wp_enqueue_style('age-gate-region', AGE_GATE_REGION_URL . 'dist/main.css', [], AGE_GATE_REGION_VERSION);
        wp_enqueue_script('age-gate-region', AGE_GATE_REGION_URL . 'dist/main.js', [], AGE_GATE_REGION_VERSION, true);
    }
}
