<?php

namespace AgeGate\Region\Admin\Ajax;

use Asylum\Validation\Validator;

class FormSubmission
{
    public function __construct()
    {
        add_action('wp_ajax_age_gate_region', [$this, 'submitForm']);
    }

    public function submitForm()
    {
        $validation = new Validator();

        $postData = $validation->sanitize($_POST ?? []);

        if ($postData['index'] > 0) {
            $data = get_option('wp_age_gate_regions', []) ?: [];
        } else {
            $data = [];
        }

        if ($postData['type'] === 'region') {
            foreach ($postData['region'] as $key => $region) {
                if (is_numeric($key)) {
                    $postData['region'][$region['code']] = $region;
                    unset($postData['region'][$key]);
                }
            }

            if ($postData['index'] > 0 && isset($data['region'])) {
                $postData['region'] = array_merge($data['region'], $postData['region']);
            }
        } else {
            $postData = array_merge($data, $postData);
        }

        foreach ($postData as $key => $value) {
            if (!in_array($key, ['region', 'labels'])) {
                unset($postData[$key]);
            }
        }


        update_option('wp_age_gate_regions', $postData);
        wp_die();
    }
}
