<?php

namespace AgeGate\Region\Traits;

trait Import
{
    private $provinces = [
        'on' => [
            'name' => 'Ontario',
            'code' => 'ON',
            'age' => '19',
        ],
        'qc' => [
            'name' => 'Quebec',
            'code' => 'QC',
            'age' => '18',
        ],
        'ns' => [
            'name' => 'Nova Scotia',
            'code' => 'NS',
            'age' => '19',
        ],
        'nb' => [
            'name' => 'New Brunswick',
            'code' => 'NB',
            'age' => '19',
        ],
        'mb' => [
            'name' => 'Manitoba',
            'code' => 'MB',
            'age' => '18',
        ],
        'bc' => [
            'name' => 'British Columbia',
            'code' => 'BC',
            'age' => '19',
        ],
        'pe' => [
            'name' => 'Prince Edward Island',
            'code' => 'PE',
            'age' => '19',
        ],
        'sk' => [
            'name' => 'Saskatchewan',
            'code' => 'SK',
            'age' => '19',
        ],
        'ab' => [
            'name' => 'Alberta',
            'code' => 'AB',
            'age' => '18',
        ],
        'nl' => [
            'name' => 'Newfoundland and Labrador',
            'code' => 'NL',
            'age' => '19',
        ],
        'nt' => [
            'name' => 'Northwest Territories',
            'code' => 'NT',
            'age' => '19',
        ],
        'yt' => [
            'name' => 'Yukon',
            'code' => 'YT',
            'age' => '19',
        ],
        'nu' => [
            'name' => 'Nunavut',
            'code' => 'NU',
            'age' => '19',
        ],
    ];

    private $states = [
        'al' => [
            'name' => 'Alabama',
            'code' => 'AL',
            'age' => '21',
        ],
        'ak' => [
            'name' => 'Alaska',
            'code' => 'AK',
            'age' => '21',
        ],
        'az' => [
            'name' => 'Arizona',
            'code' => 'AZ',
            'age' => '21',
        ],
        'ar' => [
            'name' => 'Arkansas',
            'code' => 'AR',
            'age' => '21',
        ],
        'ca' => [
            'name' => 'California',
            'code' => 'CA',
            'age' => '21',
        ],
        'co' => [
            'name' => 'Colorado',
            'code' => 'CO',
            'age' => '21',
        ],
        'ct' => [
            'name' => 'Connecticut',
            'code' => 'CT',
            'age' => '21',
        ],
        'de' => [
            'name' => 'Delaware',
            'code' => 'DE',
            'age' => '21',
        ],
        'fl' => [
            'name' => 'Florida',
            'code' => 'FL',
            'age' => '21',
        ],
        'ga' => [
            'name' => 'Georgia',
            'code' => 'GA',
            'age' => '21',
        ],
        'hi' => [
            'name' => 'Hawaii',
            'code' => 'HI',
            'age' => '21',
        ],
        'id' => [
            'name' => 'Idaho',
            'code' => 'ID',
            'age' => '21',
        ],
        'il' => [
            'name' => 'Illinois',
            'code' => 'IL',
            'age' => '21',
        ],
        'in' => [
            'name' => 'Indiana',
            'code' => 'IN',
            'age' => '21',
        ],
        'ia' => [
            'name' => 'Iowa',
            'code' => 'IA',
            'age' => '21',
        ],
        'ks' => [
            'name' => 'Kansas',
            'code' => 'KS',
            'age' => '21',
        ],
        'ky' => [
            'name' => 'Kentucky',
            'code' => 'KY',
            'age' => '21',
        ],
        'la' => [
            'name' => 'Louisiana',
            'code' => 'LA',
            'age' => '21',
        ],
        'me' => [
            'name' => 'Maine',
            'code' => 'ME',
            'age' => '21',
        ],
        'md' => [
            'name' => 'Maryland',
            'code' => 'MD',
            'age' => '21',
        ],
        'ma' => [
            'name' => 'Massachusetts',
            'code' => 'MA',
            'age' => '21',
        ],
        'mi' => [
            'name' => 'Michigan',
            'code' => 'MI',
            'age' => '21',
        ],
        'mn' => [
            'name' => 'Minnesota',
            'code' => 'MN',
            'age' => '21',
        ],
        'ms' => [
            'name' => 'Mississippi',
            'code' => 'MS',
            'age' => '21',
        ],
        'mo' => [
            'name' => 'Missouri',
            'code' => 'MO',
            'age' => '21',
        ],
        'mt' => [
            'name' => 'Montana',
            'code' => 'MT',
            'age' => '21',
        ],
        'ne' => [
            'name' => 'Nebraska',
            'code' => 'NE',
            'age' => '21',
        ],
        'nv' => [
            'name' => 'Nevada',
            'code' => 'NV',
            'age' => '21',
        ],
        'nh' => [
            'name' => 'New Hampshire',
            'code' => 'NH',
            'age' => '21',
        ],
        'nj' => [
            'name' => 'New Jersey',
            'code' => 'NJ',
            'age' => '21',
        ],
        'nm' => [
            'name' => 'New Mexico',
            'code' => 'NM',
            'age' => '21',
        ],
        'ny' => [
            'name' => 'New York',
            'code' => 'NY',
            'age' => '21',
        ],
        'nc' => [
            'name' => 'North Carolina',
            'code' => 'NC',
            'age' => '21',
        ],
        'nd' => [
            'name' => 'North Dakota',
            'code' => 'ND',
            'age' => '21',
        ],
        'oh' => [
            'name' => 'Ohio',
            'code' => 'OH',
            'age' => '21',
        ],
        'ok' => [
            'name' => 'Oklahoma',
            'code' => 'OK',
            'age' => '21',
        ],
        'or' => [
            'name' => 'Oregon',
            'code' => 'OR',
            'age' => '21',
        ],
        'pa' => [
            'name' => 'Pennsylvania',
            'code' => 'PA',
            'age' => '21',
        ],
        'ri' => [
            'name' => 'Rhode Island',
            'code' => 'RI',
            'age' => '21',
        ],
        'sc' => [
            'name' => 'South Carolina',
            'code' => 'SC',
            'age' => '21',
        ],
        'sd' => [
            'name' => 'South Dakota',
            'code' => 'SD',
            'age' => '21',
        ],
        'tn' => [
            'name' => 'Tennessee',
            'code' => 'TN',
            'age' => '21',
        ],
        'tx' => [
            'name' => 'Texas',
            'code' => 'TX',
            'age' => '21',
        ],
        'ut' => [
            'name' => 'Utah',
            'code' => 'UT',
            'age' => '21',
        ],
        'vt' => [
            'name' => 'Vermont',
            'code' => 'VT',
            'age' => '21',
        ],
        'va' => [
            'name' => 'Virginia',
            'code' => 'VA',
            'age' => '21',
        ],
        'wa' => [
            'name' => 'Washington',
            'code' => 'WA',
            'age' => '21',
        ],
        'wv' => [
            'name' => 'West Virginia',
            'code' => 'WV',
            'age' => '21',
        ],
        'wi' => [
            'name' => 'Wisconsin',
            'code' => 'WI',
            'age' => '21',
        ],
        'wy' => [
            'name' => 'Wyoming',
            'code' => 'WY',
            'age' => '21',
        ],
    ];

    private $usAdditional = [
        'as' => [
            'name' => 'American Samoa',
            'code' => 'AS',
            'age' => '21',
        ],
        'dc' => [
            'name' => 'District of Columbia',
            'code' => 'DC',
            'age' => '21',
        ],
        'fm' => [
            'name' => 'Federated States of Micronesia',
            'code' => 'FM',
            'age' => '21',
        ],
        'gu' => [
            'name' => 'Guam',
            'code' => 'GU',
            'age' => '21',
        ],
        'mh' => [
            'name' => 'Marshall Islands',
            'code' => 'MH',
            'age' => '21',
        ],
        'mp' => [
            'name' => 'Northern Mariana Islands',
            'code' => 'MP',
            'age' => '21',
        ],
        'pw' => [
            'name' => 'Palau',
            'code' => 'PW',
            'age' => '21',
        ],
        'pr' => [
            'name' => 'Puerto Rico',
            'code' => 'PR',
            'age' => '21',
        ],
        'vi' => [
            'name' => 'Virgin Islands',
            'code' => 'VI',
            'age' => '21',
        ],
        'ae' => [
            'name' => 'Armed Forces Africa',
            'code' => 'AE',
            'age' => '21',
        ],
        'aa' => [
            'name' => 'Armed Forces Americas',
            'code' => 'AA',
            'age' => '21',
        ],
        'ae' => [
            'name' => 'Armed Forces Canada',
            'code' => 'AE',
            'age' => '21',
        ],
        'ae' => [
            'name' => 'Armed Forces Europe',
            'code' => 'AE',
            'age' => '21',
        ],
        'ae' => [
            'name' => 'Armed Forces Middle East',
            'code' => 'AE',
            'age' => '21',
        ],
        'ap' => [
            'name' => 'Armed Forces Pacific',
            'code' => 'AP',
            'age' => '21',
        ],
    ];

    private $countries = [
        'bd' => [
            'name' => 'Bangladesh',
            'code' => 'BD',
            'age' => -1,
        ],
        'be' => [
            'name' => 'Belgium',
            'code' => 'BE',
            'age' => 16,
        ],
        'bf' => [
            'name' => 'Burkina Faso',
            'code' => 'BF',
            'age' => 0,
        ],
        'bg' => [
            'name' => 'Bulgaria',
            'code' => 'BG',
            'age' => 18,
        ],
        'ba' => [
            'name' => 'Bosnia and Herzegovina',
            'code' => 'BA',
            'age' => 18,
        ],
        'bb' => [
            'name' => 'Barbados',
            'code' => 'BB',
            'age' => 18,
        ],
        'wf' => [
            'name' => 'Wallis and Futuna',
            'code' => 'WF',
            'age' => '',
        ],
        'bl' => [
            'name' => 'Saint Barthelemy',
            'code' => 'BL',
            'age' => '',
        ],
        'bm' => [
            'name' => 'Bermuda',
            'code' => 'BM',
            'age' => '',
        ],
        'bn' => [
            'name' => 'Brunei',
            'code' => 'BN',
            'age' => -1,
        ],
        'bo' => [
            'name' => 'Bolivia',
            'code' => 'BO',
            'age' => 0,
        ],
        'bh' => [
            'name' => 'Bahrain',
            'code' => 'BH',
            'age' => -1,
        ],
        'bi' => [
            'name' => 'Burundi',
            'code' => 'BI',
            'age' => 18,
        ],
        'bj' => [
            'name' => 'Benin',
            'code' => 'BJ',
            'age' => 0,
        ],
        'bt' => [
            'name' => 'Bhutan',
            'code' => 'BT',
            'age' => 18,
        ],
        'jm' => [
            'name' => 'Jamaica',
            'code' => 'JM',
            'age' => 18,
        ],
        'bv' => [
            'name' => 'Bouvet Island',
            'code' => 'BV',
            'age' => '',
        ],
        'bw' => [
            'name' => 'Botswana',
            'code' => 'BW',
            'age' => 18,
        ],
        'ws' => [
            'name' => 'Samoa',
            'code' => 'WS',
            'age' => 21,
        ],
        'bq' => [
            'name' => 'Bonaire, Saint Eustatius and Saba ',
            'code' => 'BQ',
            'age' => '',
        ],
        'br' => [
            'name' => 'Brazil',
            'code' => 'BR',
            'age' => 18,
        ],
        'bs' => [
            'name' => 'Bahamas',
            'code' => 'BS',
            'age' => 18,
        ],
        'je' => [
            'name' => 'Jersey',
            'code' => 'JE',
            'age' => '',
        ],
        'by' => [
            'name' => 'Belarus',
            'code' => 'BY',
            'age' => 18,
        ],
        'bz' => [
            'name' => 'Belize',
            'code' => 'BZ',
            'age' => 18,
        ],
        'ru' => [
            'name' => 'Russia',
            'code' => 'RU',
            'age' => 18,
        ],
        'rw' => [
            'name' => 'Rwanda',
            'code' => 'RW',
            'age' => 18,
        ],
        'rs' => [
            'name' => 'Serbia',
            'code' => 'RS',
            'age' => 18,
        ],
        'tl' => [
            'name' => 'East Timor',
            'code' => 'TL',
            'age' => '',
        ],
        're' => [
            'name' => 'Reunion',
            'code' => 'RE',
            'age' => '',
        ],
        'tm' => [
            'name' => 'Turkmenistan',
            'code' => 'TM',
            'age' => 18,
        ],
        'tj' => [
            'name' => 'Tajikistan',
            'code' => 'TJ',
            'age' => 18,
        ],
        'ro' => [
            'name' => 'Romania',
            'code' => 'RO',
            'age' => 18,
        ],
        'tk' => [
            'name' => 'Tokelau',
            'code' => 'TK',
            'age' => '',
        ],
        'gw' => [
            'name' => 'Guinea-Bissau',
            'code' => 'GW',
            'age' => 0,
        ],
        'gu' => [
            'name' => 'Guam',
            'code' => 'GU',
            'age' => '',
        ],
        'gt' => [
            'name' => 'Guatemala',
            'code' => 'GT',
            'age' => 18,
        ],
        'gs' => [
            'name' => 'South Georgia and the South Sandwich Islands',
            'code' => 'GS',
            'age' => '',
        ],
        'gr' => [
            'name' => 'Greece',
            'code' => 'GR',
            'age' => 18,
        ],
        'gq' => [
            'name' => 'Equatorial Guinea',
            'code' => 'GQ',
            'age' => 21,
        ],
        'gp' => [
            'name' => 'Guadeloupe',
            'code' => 'GP',
            'age' => '',
        ],
        'jp' => [
            'name' => 'Japan',
            'code' => 'JP',
            'age' => 20,
        ],
        'gy' => [
            'name' => 'Guyana',
            'code' => 'GY',
            'age' => 18,
        ],
        'gg' => [
            'name' => 'Guernsey',
            'code' => 'GG',
            'age' => '',
        ],
        'gf' => [
            'name' => 'French Guiana',
            'code' => 'GF',
            'age' => '',
        ],
        'ge' => [
            'name' => 'Georgia',
            'code' => 'GE',
            'age' => 18,
        ],
        'gd' => [
            'name' => 'Grenada',
            'code' => 'GD',
            'age' => 16,
        ],
        'gb' => [
            'name' => 'United Kingdom',
            'code' => 'GB',
            'age' => 18,
        ],
        'ga' => [
            'name' => 'Gabon',
            'code' => 'GA',
            'age' => 18,
        ],
        'sv' => [
            'name' => 'El Salvador',
            'code' => 'SV',
            'age' => 18,
        ],
        'gn' => [
            'name' => 'Guinea',
            'code' => 'GN',
            'age' => 18,
        ],
        'gm' => [
            'name' => 'Gambia',
            'code' => 'GM',
            'age' => 18,
        ],
        'gl' => [
            'name' => 'Greenland',
            'code' => 'GL',
            'age' => '',
        ],
        'gi' => [
            'name' => 'Gibraltar',
            'code' => 'GI',
            'age' => '',
        ],
        'gh' => [
            'name' => 'Ghana',
            'code' => 'GH',
            'age' => 18,
        ],
        'om' => [
            'name' => 'Oman',
            'code' => 'OM',
            'age' => 21,
        ],
        'tn' => [
            'name' => 'Tunisia',
            'code' => 'TN',
            'age' => 18,
        ],
        'jo' => [
            'name' => 'Jordan',
            'code' => 'JO',
            'age' => 18,
        ],
        'hr' => [
            'name' => 'Croatia',
            'code' => 'HR',
            'age' => 18,
        ],
        'ht' => [
            'name' => 'Haiti',
            'code' => 'HT',
            'age' => 16,
        ],
        'hu' => [
            'name' => 'Hungary',
            'code' => 'HU',
            'age' => 18,
        ],
        'hk' => [
            'name' => 'Hong Kong',
            'code' => 'HK',
            'age' => '',
        ],
        'hn' => [
            'name' => 'Honduras',
            'code' => 'HN',
            'age' => 18,
        ],
        'hm' => [
            'name' => 'Heard Island and McDonald Islands',
            'code' => 'HM',
            'age' => '',
        ],
        've' => [
            'name' => 'Venezuela',
            'code' => 'VE',
            'age' => 18,
        ],
        'pr' => [
            'name' => 'Puerto Rico',
            'code' => 'PR',
            'age' => '',
        ],
        'ps' => [
            'name' => 'Palestinian Territory',
            'code' => 'PS',
            'age' => '',
        ],
        'pw' => [
            'name' => 'Palau',
            'code' => 'PW',
            'age' => 21,
        ],
        'pt' => [
            'name' => 'Portugal',
            'code' => 'PT',
            'age' => 16,
        ],
        'sj' => [
            'name' => 'Svalbard and Jan Mayen',
            'code' => 'SJ',
            'age' => '',
        ],
        'py' => [
            'name' => 'Paraguay',
            'code' => 'PY',
            'age' => 20,
        ],
        'iq' => [
            'name' => 'Iraq',
            'code' => 'IQ',
            'age' => 21,
        ],
        'pa' => [
            'name' => 'Panama',
            'code' => 'PA',
            'age' => 18,
        ],
        'pf' => [
            'name' => 'French Polynesia',
            'code' => 'PF',
            'age' => '',
        ],
        'pg' => [
            'name' => 'Papua New Guinea',
            'code' => 'PG',
            'age' => 18,
        ],
        'pe' => [
            'name' => 'Peru',
            'code' => 'PE',
            'age' => 18,
        ],
        'pk' => [
            'name' => 'Pakistan',
            'code' => 'PK',
            'age' => -1,
        ],
        'ph' => [
            'name' => 'Philippines',
            'code' => 'PH',
            'age' => 18,
        ],
        'pn' => [
            'name' => 'Pitcairn',
            'code' => 'PN',
            'age' => '',
        ],
        'pl' => [
            'name' => 'Poland',
            'code' => 'PL',
            'age' => 18,
        ],
        'pm' => [
            'name' => 'Saint Pierre and Miquelon',
            'code' => 'PM',
            'age' => '',
        ],
        'zm' => [
            'name' => 'Zambia',
            'code' => 'ZM',
            'age' => 18,
        ],
        'eh' => [
            'name' => 'Western Sahara',
            'code' => 'EH',
            'age' => '',
        ],
        'ee' => [
            'name' => 'Estonia',
            'code' => 'EE',
            'age' => 18,
        ],
        'eg' => [
            'name' => 'Egypt',
            'code' => 'EG',
            'age' => 18,
        ],
        'za' => [
            'name' => 'South Africa',
            'code' => 'ZA',
            'age' => 18,
        ],
        'ec' => [
            'name' => 'Ecuador',
            'code' => 'EC',
            'age' => 18,
        ],
        'it' => [
            'name' => 'Italy',
            'code' => 'IT',
            'age' => 18,
        ],
        'vn' => [
            'name' => 'Vietnam',
            'code' => 'VN',
            'age' => 18,
        ],
        'sb' => [
            'name' => 'Solomon Islands',
            'code' => 'SB',
            'age' => 0,
        ],
        'et' => [
            'name' => 'Ethiopia',
            'code' => 'ET',
            'age' => 18,
        ],
        'so' => [
            'name' => 'Somalia',
            'code' => 'SO',
            'age' => -1,
        ],
        'zw' => [
            'name' => 'Zimbabwe',
            'code' => 'ZW',
            'age' => 18,
        ],
        'sa' => [
            'name' => 'Saudi Arabia',
            'code' => 'SA',
            'age' => -1,
        ],
        'es' => [
            'name' => 'Spain',
            'code' => 'ES',
            'age' => 16,
        ],
        'er' => [
            'name' => 'Eritrea',
            'code' => 'ER',
            'age' => 18,
        ],
        'me' => [
            'name' => 'Montenegro',
            'code' => 'ME',
            'age' => 18,
        ],
        'md' => [
            'name' => 'Moldova',
            'code' => 'MD',
            'age' => 18,
        ],
        'mg' => [
            'name' => 'Madagascar',
            'code' => 'MG',
            'age' => 18,
        ],
        'mf' => [
            'name' => 'Saint Martin',
            'code' => 'MF',
            'age' => '',
        ],
        'ma' => [
            'name' => 'Morocco',
            'code' => 'MA',
            'age' => 16,
        ],
        'mc' => [
            'name' => 'Monaco',
            'code' => 'MC',
            'age' => 18,
        ],
        'uz' => [
            'name' => 'Uzbekistan',
            'code' => 'UZ',
            'age' => 20,
        ],
        'mm' => [
            'name' => 'Myanmar',
            'code' => 'MM',
            'age' => 18,
        ],
        'ml' => [
            'name' => 'Mali',
            'code' => 'ML',
            'age' => 0,
        ],
        'mo' => [
            'name' => 'Macao',
            'code' => 'MO',
            'age' => '',
        ],
        'mn' => [
            'name' => 'Mongolia',
            'code' => 'MN',
            'age' => 21,
        ],
        'mh' => [
            'name' => 'Marshall Islands',
            'code' => 'MH',
            'age' => '',
        ],
        'mk' => [
            'name' => 'Macedonia',
            'code' => 'MK',
            'age' => 18,
        ],
        'mu' => [
            'name' => 'Mauritius',
            'code' => 'MU',
            'age' => 18,
        ],
        'mt' => [
            'name' => 'Malta',
            'code' => 'MT',
            'age' => 17,
        ],
        'mw' => [
            'name' => 'Malawi',
            'code' => 'MW',
            'age' => 18,
        ],
        'mv' => [
            'name' => 'Maldives',
            'code' => 'MV',
            'age' => -1,
        ],
        'mq' => [
            'name' => 'Martinique',
            'code' => 'MQ',
            'age' => '',
        ],
        'mp' => [
            'name' => 'Northern Mariana Islands',
            'code' => 'MP',
            'age' => '',
        ],
        'ms' => [
            'name' => 'Montserrat',
            'code' => 'MS',
            'age' => '',
        ],
        'mr' => [
            'name' => 'Mauritania',
            'code' => 'MR',
            'age' => -1,
        ],
        'im' => [
            'name' => 'Isle of Man',
            'code' => 'IM',
            'age' => '',
        ],
        'ug' => [
            'name' => 'Uganda',
            'code' => 'UG',
            'age' => 18,
        ],
        'tz' => [
            'name' => 'Tanzania',
            'code' => 'TZ',
            'age' => 18,
        ],
        'my' => [
            'name' => 'Malaysia',
            'code' => 'MY',
            'age' => 18,
        ],
        'mx' => [
            'name' => 'Mexico',
            'code' => 'MX',
            'age' => 18,
        ],
        'il' => [
            'name' => 'Israel',
            'code' => 'IL',
            'age' => 18,
        ],
        'fr' => [
            'name' => 'France',
            'code' => 'FR',
            'age' => 18,
        ],
        'io' => [
            'name' => 'British Indian Ocean Territory',
            'code' => 'IO',
            'age' => '',
        ],
        'sh' => [
            'name' => 'Saint Helena',
            'code' => 'SH',
            'age' => '',
        ],
        'fi' => [
            'name' => 'Finland',
            'code' => 'FI',
            'age' => 18,
        ],
        'fj' => [
            'name' => 'Fiji',
            'code' => 'FJ',
            'age' => 18,
        ],
        'fk' => [
            'name' => 'Falkland Islands',
            'code' => 'FK',
            'age' => '',
        ],
        'fm' => [
            'name' => 'Micronesia',
            'code' => 'FM',
            'age' => 21,
        ],
        'fo' => [
            'name' => 'Faroe Islands',
            'code' => 'FO',
            'age' => '',
        ],
        'ni' => [
            'name' => 'Nicaragua',
            'code' => 'NI',
            'age' => 18,
        ],
        'nl' => [
            'name' => 'Netherlands',
            'code' => 'NL',
            'age' => 18,
        ],
        'no' => [
            'name' => 'Norway',
            'code' => 'NO',
            'age' => 18,
        ],
        'na' => [
            'name' => 'Namibia',
            'code' => 'NA',
            'age' => 18,
        ],
        'vu' => [
            'name' => 'Vanuatu',
            'code' => 'VU',
            'age' => 18,
        ],
        'nc' => [
            'name' => 'New Caledonia',
            'code' => 'NC',
            'age' => '',
        ],
        'ne' => [
            'name' => 'Niger',
            'code' => 'NE',
            'age' => 18,
        ],
        'nf' => [
            'name' => 'Norfolk Island',
            'code' => 'NF',
            'age' => '',
        ],
        'ng' => [
            'name' => 'Nigeria',
            'code' => 'NG',
            'age' => 18,
        ],
        'nz' => [
            'name' => 'New Zealand',
            'code' => 'NZ',
            'age' => 18,
        ],
        'np' => [
            'name' => 'Nepal',
            'code' => 'NP',
            'age' => 18,
        ],
        'nr' => [
            'name' => 'Nauru',
            'code' => 'NR',
            'age' => 21,
        ],
        'nu' => [
            'name' => 'Niue',
            'code' => 'NU',
            'age' => '',
        ],
        'ck' => [
            'name' => 'Cook Islands',
            'code' => 'CK',
            'age' => '',
        ],
        'xk' => [
            'name' => 'Kosovo',
            'code' => 'XK',
            'age' => '',
        ],
        'ci' => [
            'name' => 'Ivory Coast',
            'code' => 'CI',
            'age' => 21,
        ],
        'ch' => [
            'name' => 'Switzerland',
            'code' => 'CH',
            'age' => 16,
        ],
        'co' => [
            'name' => 'Colombia',
            'code' => 'CO',
            'age' => 18,
        ],
        'cn' => [
            'name' => 'China',
            'code' => 'CN',
            'age' => 0,
        ],
        'cm' => [
            'name' => 'Cameroon',
            'code' => 'CM',
            'age' => 0,
        ],
        'cl' => [
            'name' => 'Chile',
            'code' => 'CL',
            'age' => 18,
        ],
        'cc' => [
            'name' => 'Cocos Islands',
            'code' => 'CC',
            'age' => '',
        ],
        'ca' => [
            'name' => 'Canada',
            'code' => 'CA',
            'age' => 18,
        ],
        'cg' => [
            'name' => 'Republic of the Congo',
            'code' => 'CG',
            'age' => 16,
        ],
        'cf' => [
            'name' => 'Central African Republic',
            'code' => 'CF',
            'age' => 21,
        ],
        'cd' => [
            'name' => 'Democratic Republic of the Congo',
            'code' => 'CD',
            'age' => '',
        ],
        'cz' => [
            'name' => 'Czech Republic',
            'code' => 'CZ',
            'age' => 18,
        ],
        'cy' => [
            'name' => 'Cyprus',
            'code' => 'CY',
            'age' => 17,
        ],
        'cx' => [
            'name' => 'Christmas Island',
            'code' => 'CX',
            'age' => '',
        ],
        'cr' => [
            'name' => 'Costa Rica',
            'code' => 'CR',
            'age' => 18,
        ],
        'cw' => [
            'name' => 'Curacao',
            'code' => 'CW',
            'age' => '',
        ],
        'cv' => [
            'name' => 'Cape Verde',
            'code' => 'CV',
            'age' => 18,
        ],
        'cu' => [
            'name' => 'Cuba',
            'code' => 'CU',
            'age' => 18,
        ],
        'sz' => [
            'name' => 'Swaziland',
            'code' => 'SZ',
            'age' => 18,
        ],
        'sy' => [
            'name' => 'Syria',
            'code' => 'SY',
            'age' => 18,
        ],
        'sx' => [
            'name' => 'Sint Maarten',
            'code' => 'SX',
            'age' => '',
        ],
        'kg' => [
            'name' => 'Kyrgyzstan',
            'code' => 'KG',
            'age' => 18,
        ],
        'ke' => [
            'name' => 'Kenya',
            'code' => 'KE',
            'age' => 18,
        ],
        'ss' => [
            'name' => 'South Sudan',
            'code' => 'SS',
            'age' => '',
        ],
        'sr' => [
            'name' => 'Suriname',
            'code' => 'SR',
            'age' => 18,
        ],
        'ki' => [
            'name' => 'Kiribati',
            'code' => 'KI',
            'age' => 21,
        ],
        'kh' => [
            'name' => 'Cambodia',
            'code' => 'KH',
            'age' => 0,
        ],
        'kn' => [
            'name' => 'Saint Kitts and Nevis',
            'code' => 'KN',
            'age' => 18,
        ],
        'km' => [
            'name' => 'Comoros',
            'code' => 'KM',
            'age' => 18,
        ],
        'st' => [
            'name' => 'Sao Tome and Principe',
            'code' => 'ST',
            'age' => 0,
        ],
        'sk' => [
            'name' => 'Slovakia',
            'code' => 'SK',
            'age' => 18,
        ],
        'kr' => [
            'name' => 'South Korea',
            'code' => 'KR',
            'age' => 19,
        ],
        'si' => [
            'name' => 'Slovenia',
            'code' => 'SI',
            'age' => 18,
        ],
        'kp' => [
            'name' => 'North Korea',
            'code' => 'KP',
            'age' => '',
        ],
        'kw' => [
            'name' => 'Kuwait',
            'code' => 'KW',
            'age' => -1,
        ],
        'sn' => [
            'name' => 'Senegal',
            'code' => 'SN',
            'age' => 18,
        ],
        'sm' => [
            'name' => 'San Marino',
            'code' => 'SM',
            'age' => 16,
        ],
        'sl' => [
            'name' => 'Sierra Leone',
            'code' => 'SL',
            'age' => 0,
        ],
        'sc' => [
            'name' => 'Seychelles',
            'code' => 'SC',
            'age' => 18,
        ],
        'kz' => [
            'name' => 'Kazakhstan',
            'code' => 'KZ',
            'age' => 18,
        ],
        'ky' => [
            'name' => 'Cayman Islands',
            'code' => 'KY',
            'age' => '',
        ],
        'sg' => [
            'name' => 'Singapore',
            'code' => 'SG',
            'age' => 18,
        ],
        'se' => [
            'name' => 'Sweden',
            'code' => 'SE',
            'age' => 18,
        ],
        'sd' => [
            'name' => 'Sudan',
            'code' => 'SD',
            'age' => -1,
        ],
        'do' => [
            'name' => 'Dominican Republic',
            'code' => 'DO',
            'age' => 18,
        ],
        'dm' => [
            'name' => 'Dominica',
            'code' => 'DM',
            'age' => 16,
        ],
        'dj' => [
            'name' => 'Djibouti',
            'code' => 'DJ',
            'age' => '',
        ],
        'dk' => [
            'name' => 'Denmark',
            'code' => 'DK',
            'age' => 18,
        ],
        'vg' => [
            'name' => 'British Virgin Islands',
            'code' => 'VG',
            'age' => '',
        ],
        'de' => [
            'name' => 'Germany',
            'code' => 'DE',
            'age' => 16,
        ],
        'ye' => [
            'name' => 'Yemen',
            'code' => 'YE',
            'age' => -1,
        ],
        'dz' => [
            'name' => 'Algeria',
            'code' => 'DZ',
            'age' => 18,
        ],
        'us' => [
            'name' => 'United States',
            'code' => 'US',
            'age' => 21,
        ],
        'uy' => [
            'name' => 'Uruguay',
            'code' => 'UY',
            'age' => 18,
        ],
        'yt' => [
            'name' => 'Mayotte',
            'code' => 'YT',
            'age' => '',
        ],
        'um' => [
            'name' => 'United States Minor Outlying Islands',
            'code' => 'UM',
            'age' => '',
        ],
        'lb' => [
            'name' => 'Lebanon',
            'code' => 'LB',
            'age' => '',
        ],
        'lc' => [
            'name' => 'Saint Lucia',
            'code' => 'LC',
            'age' => 16,
        ],
        'la' => [
            'name' => 'Laos',
            'code' => 'LA',
            'age' => 18,
        ],
        'tv' => [
            'name' => 'Tuvalu',
            'code' => 'TV',
            'age' => 18,
        ],
        'tw' => [
            'name' => 'Taiwan',
            'code' => 'TW',
            'age' => '',
        ],
        'tt' => [
            'name' => 'Trinidad and Tobago',
            'code' => 'TT',
            'age' => 18,
        ],
        'tr' => [
            'name' => 'Turkey',
            'code' => 'TR',
            'age' => 18,
        ],
        'lk' => [
            'name' => 'Sri Lanka',
            'code' => 'LK',
            'age' => 21,
        ],
        'li' => [
            'name' => 'Liechtenstein',
            'code' => 'LI',
            'age' => 16,
        ],
        'lv' => [
            'name' => 'Latvia',
            'code' => 'LV',
            'age' => 18,
        ],
        'to' => [
            'name' => 'Tonga',
            'code' => 'TO',
            'age' => 18,
        ],
        'lt' => [
            'name' => 'Lithuania',
            'code' => 'LT',
            'age' => 18,
        ],
        'lu' => [
            'name' => 'Luxembourg',
            'code' => 'LU',
            'age' => 16,
        ],
        'lr' => [
            'name' => 'Liberia',
            'code' => 'LR',
            'age' => 18,
        ],
        'ls' => [
            'name' => 'Lesotho',
            'code' => 'LS',
            'age' => 18,
        ],
        'th' => [
            'name' => 'Thailand',
            'code' => 'TH',
            'age' => 20,
        ],
        'tf' => [
            'name' => 'French Southern Territories',
            'code' => 'TF',
            'age' => '',
        ],
        'tg' => [
            'name' => 'Togo',
            'code' => 'TG',
            'age' => 0,
        ],
        'td' => [
            'name' => 'Chad',
            'code' => 'TD',
            'age' => 18,
        ],
        'tc' => [
            'name' => 'Turks and Caicos Islands',
            'code' => 'TC',
            'age' => '',
        ],
        'ly' => [
            'name' => 'Libya',
            'code' => 'LY',
            'age' => -1,
        ],
        'va' => [
            'name' => 'Vatican',
            'code' => 'VA',
            'age' => '',
        ],
        'vc' => [
            'name' => 'Saint Vincent and the Grenadines',
            'code' => 'VC',
            'age' => 16,
        ],
        'ae' => [
            'name' => 'United Arab Emirates',
            'code' => 'AE',
            'age' => -1,
        ],
        'ad' => [
            'name' => 'Andorra',
            'code' => 'AD',
            'age' => 18,
        ],
        'ag' => [
            'name' => 'Antigua and Barbuda',
            'code' => 'AG',
            'age' => 10,
        ],
        'af' => [
            'name' => 'Afghanistan',
            'code' => 'AF',
            'age' => -1,
        ],
        'ai' => [
            'name' => 'Anguilla',
            'code' => 'AI',
            'age' => '',
        ],
        'vi' => [
            'name' => 'U.S. Virgin Islands',
            'code' => 'VI',
            'age' => '',
        ],
        'is' => [
            'name' => 'Iceland',
            'code' => 'IS',
            'age' => 20,
        ],
        'ir' => [
            'name' => 'Iran',
            'code' => 'IR',
            'age' => -1,
        ],
        'am' => [
            'name' => 'Armenia',
            'code' => 'AM',
            'age' => 18,
        ],
        'al' => [
            'name' => 'Albania',
            'code' => 'AL',
            'age' => 18,
        ],
        'ao' => [
            'name' => 'Angola',
            'code' => 'AO',
            'age' => 18,
        ],
        'aq' => [
            'name' => 'Antarctica',
            'code' => 'AQ',
            'age' => '',
        ],
        'as' => [
            'name' => 'American Samoa',
            'code' => 'AS',
            'age' => '',
        ],
        'ar' => [
            'name' => 'Argentina',
            'code' => 'AR',
            'age' => 18,
        ],
        'au' => [
            'name' => 'Australia',
            'code' => 'AU',
            'age' => 18,
        ],
        'at' => [
            'name' => 'Austria',
            'code' => 'AT',
            'age' => 16,
        ],
        'aw' => [
            'name' => 'Aruba',
            'code' => 'AW',
            'age' => '',
        ],
        'in' => [
            'name' => 'India',
            'code' => 'IN',
            'age' => 18,
        ],
        'ax' => [
            'name' => 'Aland Islands',
            'code' => 'AX',
            'age' => '',
        ],
        'az' => [
            'name' => 'Azerbaijan',
            'code' => 'AZ',
            'age' => 18,
        ],
        'ie' => [
            'name' => 'Ireland',
            'code' => 'IE',
            'age' => 18,
        ],
        'id' => [
            'name' => 'Indonesia',
            'code' => 'ID',
            'age' => 0,
        ],
        'ua' => [
            'name' => 'Ukraine',
            'code' => 'UA',
            'age' => 18,
        ],
        'qa' => [
            'name' => 'Qatar',
            'code' => 'QA',
            'age' => -1,
        ],
        'mz' => [
            'name' => 'Mozambique',
            'code' => 'MZ',
            'age' => 18,
        ],
    ];
}
