<?php

namespace AgeGate\Region\Presentation;

use AgeGate\Common\Settings;

class Restriction
{
    protected $options = [];

    public function __construct()
    {
        $this->options = get_option('wp_age_gate_regions', []);
        add_filter('age_gate/content/age', [$this, 'applyAge'], 10, 2);
        add_filter('age_gate/content/ages', [$this, 'appendAge'], 10, 2);
        // add_filter('age_gate/restricted', [$this, 'checkRestriction']);
    }

    public function applyAge($age, $settings)
    {
        $cookieName = $settings->getCookieName();

        if (empty($_COOKIE[$cookieName . '_region']) || empty($_COOKIE[$cookieName])) {
            return $age;
        }

        if ($this->options['region'][$_COOKIE[$cookieName . '_region']]['age'] ?? false) {
            return (int) $this->options['region'][$_COOKIE[$cookieName . '_region']]['age'];
        }


        return $age;
    }

    public function appendAge($ages, $settings)
    {
        $cookieName = $settings->getCookieName();

        if (empty($_COOKIE[$cookieName . '_region']) || empty($_COOKIE[$cookieName])) {
            return $ages;
        }

        if ($this->options['region'][$_COOKIE[$cookieName . '_region']]['age'] ?? false) {
            $ages[] = (int) $this->options['region'][$_COOKIE[$cookieName . '_region']]['age'];
        }

        return $ages;
    }

    public function checkRestriction($status)
    {
        $settings = Settings::getInstance();

        if ($settings->method === 'js') {
            return $status;
        }

        $cookieName = $settings->getCookieName();

        if (empty($_COOKIE[$cookieName . '_region']) || empty($_COOKIE[$cookieName])) {
            return $status;
        }

        if ($_COOKIE[$cookieName] >= $_COOKIE[$cookieName . '_region']) {
            return false;
        }

        return $status;
    }
}
