<?php

/**
 * Plugin Name:       	 Age Gate Region
 * Description:       	 Change the Age Gate age requirement based on region e.g. Country, State or Province
 * Version:           	 2.0.6
 * Requires at least:    6.0.0
 * Requires PHP:         7.4
 * Author:            	 Phil Baker
 * Author URI:        	 https://agegate.io/
 * Text Domain:       	 age-gate-region
 * Domain Path:          /languages
 */

if (!defined('WPINC')) {
    die;
}

define('AGE_GATE_REGION_PATH', plugin_dir_path(__FILE__));
define('AGE_GATE_REGION_URL', plugin_dir_url(__FILE__));
define('AGE_GATE_REGION_VERSION', '2.0.6');
define('AGE_GATE_REGION_DEPENDANCY', '3.0.5');
define('AGE_GATE_REGION_SLUG', 'age-gate-region');

require_once('vendor/autoload.php');
require_once('src/Bootstrap.php');

function age_gate_region_activate()
{
    \AgeGate\Region\Update\Activate::activate();
}

function age_gate_region_deactivate()
{
    \AgeGate\Region\Update\Deactivate::deactivate();
}

function age_gate_region_uninstall()
{
    \AgeGate\Region\Update\Uninstall::uninstall();
}

register_activation_hook(__FILE__, 'age_gate_region_activate');
register_deactivation_hook(__FILE__, 'age_gate_region_deactivate');
register_uninstall_hook(__FILE__, 'age_gate_region_uninstall');
