import Cookies from 'js-cookie';

const listener = [...document.body.parentNode.classList].some(r => ['age-gate-restricted-standard', 'age-gate__restricted--standard'].indexOf(r) >= 0) ? 'DOMContentLoaded' : 'age_gate_shown';

window.addEventListener(listener, () => {
    const selector = document.querySelector('.age-gate__region');

    selector.addEventListener('change', function() {
        const { headline, subheadline, button } = this.options[this.selectedIndex].dataset;

        const headlineElement = document.querySelector('.age-gate__headline, .age-gate-headline');
        const subheadlineElement = document.querySelector('.age-gate__subheadline, .age-gate-subheadline');
        const challengeElement = document.querySelector('.age-gate__challenge, .age-gate-challenge');

        if (headlineElement && headline) {
            headlineElement.textContent = headline;
        }

        if (subheadlineElement && subheadline) {
            subheadlineElement.textContent = subheadline;
        }

        if (challengeElement && button) {
            challengeElement.textContent = button;
        }

    });
});


window.addEventListener('age_gate_passed', function(e) {

    const {
        cookieDomain,
        cookieName,
    } = window.age_gate;

    const {
        detail: {
            cookieLength,
            user_data: {
                region,
            },
        },
    } = e;

    const cookieOptions = {
        path: '/',
        domain: cookieDomain,
        secure: window.location.protocol.match(/https/) ? true : false,
        sameSite: window.location.protocol.match(/https/) ? 'None' : false,
    }

    if (cookieLength) {
        Object.assign(cookieOptions, { expires: cookieLength });
    }

    Cookies.set(`${cookieName}_region`, region, cookieOptions);
});
