<?php

namespace AgeGate\Region\Admin\Controller;

use AgeGate\Common\Admin\AbstractController;

class RegionController extends AbstractController
{
    public const PERMISSION = 'manage_options'; //'age_gate_manage_regions';
    public const OPTION = 'wp_age_gate_regions';

    protected $template = 'regions::admin';

    public function register(): void
    {
        $this->menu('Region', self::PERMISSION);
    }

    protected function required(): bool
    {
        return true;
    }

    protected function data(): array
    {
        return get_option(self::OPTION, []);
    }

    protected function fields(): array
    {
        return [];
    }
}
