<?php

/**
 * Plugin Name:       	 Age Gate User Registration
 * Description:       	 An Age Gate addon to check the age of users registering or using WooCommerce
 * Version:           	 1.0.1
 * Author:            	 Phil Baker
 * Author URI:        	 https://www.agegate.io/addons/age-gate-user-registration
 * Text Domain:       	 age-gate-user-registration
 */

 if (!defined('WPINC')) {
     die;
 }

define('AGE_GATE_USER_REGISTRATION_PATH', plugin_dir_path(__FILE__));
define('AGE_GATE_USER_REGISTRATION_URL', plugin_dir_url(__FILE__));
define('AGE_GATE_USER_REGISTRATION_VERSION', '1.0.1');
define('AGE_GATE_USER_REGISTRATION_SLUG', 'age-gate-user-registration');
define('AGE_GATE_USER_PARENT_VERSION', '3.1.0');



require_once('vendor/autoload.php');
require_once('src/Bootstrap.php');

function age_gate_user_registration_activate()
{
    \AgeGate\UserRegistration\Update\Activate::activate();
}

function age_gate_user_registration_deactivate()
{
    \AgeGate\UserRegistration\Update\Deactivate::deactivate();
}

function age_gate_user_registration_uninstall()
{
    \AgeGate\UserRegistration\Update\Uninstall::uninstall();
}

register_activation_hook(__FILE__, 'age_gate_user_registration_activate');
register_deactivation_hook(__FILE__, 'age_gate_user_registration_deactivate');
register_uninstall_hook( __FILE__,  'age_gate_user_registration_uninstall');
