<?php

namespace AgeGate\UserRegistration\Settings;

class Settings
{
    private $data = [];
    private static $instance = null;

    public static function getInstance()
    {
        if (self::$instance === null) {
            self::$instance = new Settings;
        }

        return self::$instance;
    }

    private function __construct()
    {
        $options = get_option('wp_age_gate_addon_age-gate-user-registration', []);

        foreach ($options as $option => $value) {
            $this->data[$this->snakeToCamel($option)] = $value;
        }
    }

    public function __get($prop)
    {
        return $this->data[$prop] ?? false;
    }

    private function snakeToCamel($input)
    {
        // return lcfirst(str_replace('', '', ucwords($input, '')));
        return lcfirst(str_replace(' ', '', ucwords(str_replace('_', ' ', $input))));
    }

}
