<?php

namespace AgeGate\UserRegistration\Admin\Settings;

trait Registration
{
    protected function getRegistrationFields()
    {
        $fields = [
            [
                'title' => 'Options',
                'model' => ['restrict_register', 'store_dob'],
                'fields' => [
                ]

            ]
        ];

        // can reigster?
        $fields[0]['fields']['restrict_register'] = [
            'label' => __('Restrict registration', 'age-gate-user-registration'),
            'subtext' => sprintf('Age check users during %s registration', (class_exists('BuddyPress') ? 'BuddyPress' : 'WordPress')),
            'type' => 'checkbox',
            'default' => true,
            'attributes' => [
                'x-on:change' => 'restrict_register = $el.checked',
            ]
        ];

        // has Woocommerce
        if (class_exists('WooCommerce')) {
            $fields[0]['fields']['restrict_register_woocommerce'] = [
                'label' => '',
                'subtext' => __('Age check users during WooCommerce registration', 'age-gate-user-registration'),
                'type' => 'checkbox',
                'condition' => [
                    'x-show' => 'restrict_register',
                ],
                'attributes' => [
                    'class' => 'small-text',
                ]
            ];

            $fields[0]['fields']['restrict_checkout_woocommerce'] = [
                'label' => '',
                'subtext' => __('Age check users during WooCommerce checkout', 'age-gate-user-registration'),
                'type' => 'checkbox',
                'condition' => [
                    'x-show' => 'restrict_register',
                ],
                'attributes' => [
                    'class' => 'small-text',
                ]
            ];
        }

        $fields[0]['fields']['register_age'] = [
            'label' => __('Registration age', 'age-gate-user-registration'),
            'subtext' => 'years or older to register (Leave blank to use age from Age Gate Restriction settings)',
            'type' => 'number',
            'condition' => [
                'x-show' => 'restrict_register',
            ],
            'attributes' => [
                'class' => 'small-text',
            ]
        ];

        $fields[0]['fields']['store_dob'] = [
            'label' => __('Store Date of Birth', 'age-gate-user-registration'),
            'subtext' => 'Store users date of birth when registering',
            'type' => 'checkbox',
            'default' => false,
            'condition' => [
                'x-show' => 'restrict_register',
            ],
            'attributes' => [
                'x-on:change' => 'store_dob = $el.checked',
            ]
        ];

        $fields[0]['fields']['set_age'] = [
            'label' => __('Set age on login', 'age-gate-user-registration'),
            'subtext' => 'Users with stored date of birth will have it set on login',
            'type' => 'checkbox',
            'default' => true,
            'condition' => [
                'x-show' => 'restrict_register && store_dob',
            ],
        ];

        $fields[0]['fields']['invalid_error'] = [
            'label' => __('Invalid Error', 'age-gate-user-registration'),
            'type' => 'text',
            'default' => false,
            'condition' => [
                'x-show' => 'restrict_register',
            ],
            'attributes' => [
                'class' => 'regular-text',
            ]
        ];

        $fields[0]['fields']['registration_error'] = [
            'label' => __('Registration Error', 'age-gate-user-registration'),
            'type' => 'text',
            'default' => false,
            'condition' => [
                'x-show' => 'restrict_register',
            ],
            'attributes' => [
                'class' => 'regular-text',
            ]
        ];

        $fields[0]['fields']['account_error'] = [
            'label' => __('Account Error', 'age-gate-user-registration'),
            'type' => 'text',
            'default' => false,
            'condition' => [
                'x-show' => 'restrict_register',
            ],
            'attributes' => [
                'class' => 'regular-text',
            ]
        ];

        $fields[0]['fields']['checkout_error'] = [
            'label' => __('Checkout Error', 'age-gate-user-registration'),
            'type' => 'text',
            'default' => false,
            'condition' => [
                'x-show' => 'restrict_register',
            ],
            'attributes' => [
                'class' => 'regular-text',
            ]
        ];


        // "invalid_error" => "Please enter a valid date"
        // "registration_error" => "Sorry, you must be over %s to register"
        // "account_error" => "Sorry, you must be over %s"
        // "checkout_error" => "Sorry, you must be over %s to purchase"

        return $fields;
    }
}
